<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'password', 'phone', 'type', 'city_id');

    public function jobs()
    {
        return $this->hasMany('Job');
    }

    public function applications()
    {
        return $this->hasMany('Application');
    }

    public function notifications()
    {
        return $this->hasMany('Notification');
    }

    public function categories()
    {
        return $this->belongsToMany('Category');
    }

}